<?php
/**
 * Get Sidebar Preference API
 */

session_start();
require_once '../../config/database.php';

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

$user_id = $_SESSION['admin_user_id'];

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Get sidebar preference from admin_settings table
    $stmt = $conn->prepare("SELECT setting_value FROM admin_settings WHERE user_id = ? AND setting_key = 'sidebar_collapsed'");
    $stmt->execute([$user_id]);
    $result = $stmt->fetch();
    
    $sidebar_collapsed = false;
    if ($result && $result['setting_value'] === 'true') {
        $sidebar_collapsed = true;
    }
    
    echo json_encode([
        'success' => true,
        'sidebar_collapsed' => $sidebar_collapsed
    ]);
    
} catch (Exception $e) {
    error_log("Error getting sidebar preference: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Fehler beim Laden']);
}
?>
