<?php
/**
 * API: Feedback Details abrufen
 */

session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$feedback_id = $_GET['id'] ?? null;

if (!$feedback_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Feedback-ID fehlt']);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $stmt = $conn->prepare("
        SELECT f.*, 
               u.first_name, u.last_name, u.email,
               a.name as autohaus_name,
               admin.username as admin_response_by_name
        FROM feedback f
        LEFT JOIN users u ON f.user_id = u.id
        LEFT JOIN autohaus a ON f.autohaus_id = a.id
        LEFT JOIN admin_users admin ON f.admin_response_by = admin.id
        WHERE f.id = ?
    ");
    $stmt->execute([$feedback_id]);
    $feedback = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$feedback) {
        http_response_code(404);
        echo json_encode(['success' => false, 'error' => 'Feedback nicht gefunden']);
        exit;
    }
    
    // Als gelesen markieren wenn noch "new"
    $current_user_id = $_SESSION['admin_user_id'] ?? null;
    if ($feedback['status'] === 'new') {
        $stmt = $conn->prepare("UPDATE feedback SET status = 'read' WHERE id = ?");
        $stmt->execute([$feedback_id]);
        $feedback['status'] = 'read';
        
        // Audit-Log: Als gelesen markiert
        try {
            $checkTable = $conn->query("SHOW TABLES LIKE 'feedback_audit_log'");
            if ($checkTable->rowCount() > 0 && $current_user_id) {
                $auditStmt = $conn->prepare("
                    INSERT INTO feedback_audit_log 
                    (feedback_id, admin_user_id, action_type, action_description, old_value, new_value)
                    VALUES (?, ?, 'viewed', 'Feedback als gelesen markiert', 'Neu', 'Gelesen')
                ");
                $auditStmt->execute([$feedback_id, $current_user_id]);
            }
        } catch (PDOException $e) {
            // Nicht kritisch
        }
    } else {
        // Audit-Log: Feedback angesehen
        try {
            $checkTable = $conn->query("SHOW TABLES LIKE 'feedback_audit_log'");
            if ($checkTable->rowCount() > 0 && $current_user_id) {
                // Prüfe ob bereits heute angesehen
                $checkView = $conn->prepare("
                    SELECT id FROM feedback_audit_log 
                    WHERE feedback_id = ? AND admin_user_id = ? AND action_type = 'viewed' 
                    AND DATE(created_at) = CURDATE()
                    LIMIT 1
                ");
                $checkView->execute([$feedback_id, $current_user_id]);
                
                if ($checkView->rowCount() == 0) {
                    $auditStmt = $conn->prepare("
                        INSERT INTO feedback_audit_log 
                        (feedback_id, admin_user_id, action_type, action_description)
                        VALUES (?, ?, 'viewed', 'Feedback angesehen')
                    ");
                    $auditStmt->execute([$feedback_id, $current_user_id]);
                }
            }
        } catch (PDOException $e) {
            // Nicht kritisch
        }
    }
    
    // Lade Audit-Log
    $auditLog = [];
    try {
        $checkTable = $conn->query("SHOW TABLES LIKE 'feedback_audit_log'");
        if ($checkTable->rowCount() > 0) {
            $auditStmt = $conn->prepare("
                SELECT 
                    fal.*,
                    au.username as admin_username,
                    au.role as admin_role
                FROM feedback_audit_log fal
                LEFT JOIN admin_users au ON fal.admin_user_id = au.id
                WHERE fal.feedback_id = ?
                ORDER BY fal.created_at DESC
            ");
            $auditStmt->execute([$feedback_id]);
            $auditLog = $auditStmt->fetchAll(PDO::FETCH_ASSOC);
        }
    } catch (PDOException $e) {
        error_log("Fehler beim Laden des Audit-Logs: " . $e->getMessage());
    }
    
    echo json_encode([
        'success' => true,
        'feedback' => $feedback,
        'audit_log' => $auditLog
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Fehler beim Laden des Feedbacks'
    ]);
}

