<?php
/**
 * AJAX-Endpoint: Lädt Drucker-Einstellungen für ein Autohaus
 */

session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$autohausId = $_GET['autohaus_id'] ?? null;

if (!$autohausId) {
    echo json_encode(['success' => false, 'error' => 'Keine Autohaus-ID angegeben']);
    exit;
}

try {
    require_once '../../config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    $stmt = $conn->prepare("
        SELECT 
            printer_name, printer_name_local, printer_name_server,
            printer_server_ip, printer_server_hostname,
            printer_enabled
        FROM autohaus 
        WHERE id = ? AND is_active = 1
    ");
    $stmt->execute([$autohausId]);
    $printer = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($printer) {
        echo json_encode([
            'success' => true,
            'printer' => $printer
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Autohaus nicht gefunden'
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>







