<?php
/**
 * AJAX-Endpoint: Lädt E-Mail-Einstellungen für ein Autohaus
 */

session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$autohausId = $_GET['autohaus_id'] ?? null;

if (!$autohausId) {
    echo json_encode(['success' => false, 'error' => 'Keine Autohaus-ID angegeben']);
    exit;
}

try {
    require_once '../../config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    $stmt = $conn->prepare("
        SELECT 
            email_smtp_host, email_smtp_port, email_smtp_username, 
            email_smtp_password, email_smtp_encryption, email_from_name, email
        FROM autohaus 
        WHERE id = ? AND is_active = 1
    ");
    $stmt->execute([$autohausId]);
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($settings) {
        echo json_encode([
            'success' => true,
            'settings' => $settings
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Autohaus nicht gefunden'
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
















