<?php
/**
 * API: Hole Termine für Test-Versand
 */

session_start();
require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json');

// Prüfe ob Admin eingeloggt ist
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$autohausId = $_GET['autohaus_id'] ?? null;

if (!$autohausId) {
    echo json_encode(['success' => false, 'error' => 'Autohaus-ID fehlt']);
    exit;
}

try {
    // Hole Termine mit Telefonnummer (maximal 50 für Dropdown)
    $stmt = $conn->prepare("
        SELECT a.id, a.customer_name, a.phone, a.slot_date, a.slot_time, a.status
        FROM appointments a 
        WHERE a.autohaus_id = ? 
        AND (a.phone IS NOT NULL AND a.phone != '')
        AND a.status IN ('booked', 'approved', 'vorbereitet')
        ORDER BY a.slot_date DESC, a.slot_time DESC
        LIMIT 50
    ");
    $stmt->execute([$autohausId]);
    $appointments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'data' => $appointments]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}




