<?php
/**
 * Get Admin Actions History API
 * Returns all admin actions for a specific user
 */

session_start();
header('Content-Type: application/json');

// Check if user is logged in as admin
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized - Please log in as admin']);
    exit;
}

require_once __DIR__ . '/../../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $user_id = intval($_GET['user_id'] ?? 0);
    
    if (!$user_id) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'User ID required']);
        exit;
    }
    
    // Check if admin_actions table exists
    $tableCheck = $conn->query("SHOW TABLES LIKE 'admin_actions'");
    if ($tableCheck->rowCount() === 0) {
        echo json_encode(['success' => true, 'actions' => []]);
        exit;
    }
    
    // Get all admin actions for this user
    $stmt = $conn->prepare("
        SELECT 
            aa.id,
            aa.action,
            aa.reason,
            aa.created_at,
            au.username as admin_name,
            au.role as admin_role
        FROM admin_actions aa
        LEFT JOIN admin_users au ON aa.admin_id = au.id
        WHERE aa.user_id = ?
        ORDER BY aa.created_at DESC
        LIMIT 50
    ");
    $stmt->execute([$user_id]);
    $actions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'actions' => $actions
    ]);
    
} catch (Exception $e) {
    error_log("Error getting admin actions: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Internal server error']);
}
?>







