<?php
/**
 * API: Feedback als CSV exportieren
 */

session_start();
require_once '../../config/database.php';

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: ../login.php');
    exit;
}

$current_user_id = $_SESSION['admin_user_id'] ?? null;
$current_user_role = 'admin';
$current_user_autohaus_id = null;

if ($current_user_id) {
    $db = new Database();
    $conn = $db->getConnection();
    $stmt = $conn->prepare("SELECT role, autohaus_id FROM admin_users WHERE id = ?");
    $stmt->execute([$current_user_id]);
    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
    $current_user_role = $user_data['role'] ?? 'admin';
    $current_user_autohaus_id = $user_data['autohaus_id'];
}

// Filter
$filter_status = $_GET['status'] ?? 'all';
$filter_autohaus = $_GET['autohaus_id'] ?? 'all';
$filter_type = $_GET['type'] ?? 'all';
$filter_rating = $_GET['rating'] ?? 'all';
$search_query = $_GET['search'] ?? '';

// Lade Feedback mit Filtern
$where_conditions = [];
$params = [];

if ($filter_status !== 'all') {
    $where_conditions[] = "f.status = ?";
    $params[] = $filter_status;
}

if ($filter_autohaus !== 'all') {
    $where_conditions[] = "f.autohaus_id = ?";
    $params[] = $filter_autohaus;
}

if ($filter_type !== 'all') {
    $where_conditions[] = "f.feedback_type = ?";
    $params[] = $filter_type;
}

if ($filter_rating !== 'all') {
    $where_conditions[] = "f.rating = ?";
    $params[] = $filter_rating;
}

if (!empty($search_query)) {
    $where_conditions[] = "(f.feedback_text LIKE ? OR u.first_name LIKE ? OR u.last_name LIKE ? OR u.email LIKE ?)";
    $search_param = "%{$search_query}%";
    $params[] = $search_param;
    $params[] = $search_param;
    $params[] = $search_param;
    $params[] = $search_param;
}

if ($current_user_autohaus_id && $current_user_role !== 'super_admin') {
    $where_conditions[] = "f.autohaus_id = ?";
    $params[] = $current_user_autohaus_id;
}

$where_clause = !empty($where_conditions) ? "WHERE " . implode(" AND ", $where_conditions) : "";

$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("
    SELECT f.*, 
           u.first_name, u.last_name, u.email,
           a.name as autohaus_name,
           admin.username as admin_response_by_name
    FROM feedback f
    LEFT JOIN users u ON f.user_id = u.id
    LEFT JOIN autohaus a ON f.autohaus_id = a.id
    LEFT JOIN admin_users admin ON f.admin_response_by = admin.id
    $where_clause
    ORDER BY f.created_at DESC
");
$stmt->execute($params);
$feedback_list = $stmt->fetchAll(PDO::FETCH_ASSOC);

// CSV Header
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="feedback_export_' . date('Y-m-d_His') . '.csv"');

// UTF-8 BOM für Excel
echo "\xEF\xBB\xBF";

$output = fopen('php://output', 'w');

// CSV Header
fputcsv($output, [
    'ID',
    'Bewertung',
    'Feedback-Text',
    'Typ',
    'Status',
    'Benutzer',
    'E-Mail',
    'Anonym',
    'Autohaus',
    'Seite',
    'Admin-Antwort',
    'Antwort von',
    'Antwort am',
    'Erstellt am'
], ';');

// CSV Daten
foreach ($feedback_list as $fb) {
    $user_name = '';
    if ($fb['is_anonymous']) {
        $user_name = 'Anonym';
    } elseif ($fb['first_name']) {
        $user_name = $fb['first_name'] . ' ' . $fb['last_name'];
    }
    
    $status_labels = [
        'new' => 'Neu',
        'read' => 'Gelesen',
        'archived' => 'Archiviert'
    ];
    
    $type_labels = [
        'service' => 'Service',
        'booking' => 'Buchung',
        'general' => 'Allgemein'
    ];
    
    fputcsv($output, [
        $fb['id'],
        $fb['rating'],
        $fb['feedback_text'],
        $type_labels[$fb['feedback_type']] ?? $fb['feedback_type'],
        $status_labels[$fb['status']] ?? $fb['status'],
        $user_name,
        $fb['email'] ?? '',
        $fb['is_anonymous'] ? 'Ja' : 'Nein',
        $fb['autohaus_name'] ?? '',
        $fb['page_url'] ?? '',
        $fb['admin_response'] ?? '',
        $fb['admin_response_by_name'] ?? '',
        $fb['admin_response_at'] ? date('d.m.Y H:i', strtotime($fb['admin_response_at'])) : '',
        date('d.m.Y H:i', strtotime($fb['created_at']))
    ], ';');
}

fclose($output);
exit;









