<?php
/**
 * Direct Test of Suspend API
 */

// Start session and set admin session
session_start();
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_user_id'] = 1;

echo "Testing Suspend API directly...\n";

// Include the suspend API
try {
    // Simulate POST data
    $_SERVER['REQUEST_METHOD'] = 'POST';
    
    // Create test input
    $testData = [
        'user_id' => 10,
        'action' => 'suspend',
        'reason' => 'Test suspension'
    ];
    
    // Mock the input stream by creating a temporary file
    $tempFile = tempnam(sys_get_temp_dir(), 'test_input');
    file_put_contents($tempFile, json_encode($testData));
    
    // Override php://input by using a stream wrapper
    stream_wrapper_unregister('php');
    stream_wrapper_register('php', 'TestStreamWrapper');
    
    class TestStreamWrapper {
        private $position = 0;
        private $data;
        
        public function stream_open($path, $mode, $options, &$opened_path) {
            global $testData;
            $this->data = json_encode($testData);
            return true;
        }
        
        public function stream_read($count) {
            $ret = substr($this->data, $this->position, $count);
            $this->position += strlen($ret);
            return $ret;
        }
        
        public function stream_eof() {
            return $this->position >= strlen($this->data);
        }
        
        public function stream_stat() {
            return [];
        }
    }
    
    // Capture output
    ob_start();
    
    // Include the API
    include 'suspend_user.php';
    
    $output = ob_get_clean();
    
    echo "API Output: $output\n";
    
    // Try to decode as JSON
    $decoded = json_decode($output, true);
    if ($decoded) {
        echo "Decoded response:\n";
        print_r($decoded);
    } else {
        echo "Failed to decode JSON\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
