<?php
/**
 * API: Lösche Template-Konfiguration
 */

require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Nur POST erlaubt']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$data = json_decode(file_get_contents('php://input'), true);

$configId = $data['config_id'] ?? null;

if (!$configId) {
    echo json_encode(['success' => false, 'error' => 'Config-ID ist erforderlich']);
    exit;
}

try {
    $stmt = $conn->prepare("DELETE FROM whatsapp_template_configs WHERE id = ?");
    $stmt->execute([$configId]);
    
    echo json_encode(['success' => true, 'message' => 'Konfiguration gelöscht']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}





