// Aktiviert alle wichtigen Spalten in RESY vor dem Daten-Abruf

async function activateAllColumns(page) {
    console.log('[4a/5] Aktiviere alle wichtigen Spalten...');
    
    // Klicke auf "Spalten wählen" Button
    await page.click('button.button_colselect');
    await page.waitForTimeout(1000);
    
    // Warte auf ColSelector-Dialog
    const colSelector = await page.waitForSelector('#WheelsetSearchResultColSelector', {
        state: 'visible'
    });
    
    if (!colSelector) {
        console.log('⚠️  ColSelector nicht gefunden, überspringe Spalten-Aktivierung');
        return;
    }
    
    // Liste aller Spalten die aktiviert werden sollen (basierend auf dem HTML)
    const columnsToActivate = [
        'checkboxLGS_ID',           // Satznummer
        'checkboxNAME1',            // Haltername
        'checkboxKENNZEICHEN',     // Kennzeichen
        'checkboxFAHRGESTNR',      // FIN
        'checkboxRFMODELL_ID',     // Reifenmodell (⚠️ WICHTIG!)
        'checkboxKD_ID',           // Autohaus
        'checkboxRUECKKDNAME',     // Ziel-Autohaus
        'checkboxEINGANG',          // Eingangsdatum
        'checkboxRUECKLIEFERTERMIN', // Rückliefertermin
        'checkboxRFARTSUCH_ID',     // Reifenart (⚠️ WICHTIG!)
        'checkboxSAIS_ID',          // Saison (⚠️ WICHTIG!)
        'checkboxRUECKAKTBEMERKUNG', // Rückgabe Bemerkung
        'checkboxMAXEMPFEHL_ID',     // Empfehlung (⚠️ WICHTIG!)
        'checkboxWEBUSER',          // bestellt durch
        'checkboxVL_GROSS',        // Reifengröße (⚠️ WICHTIG!)
        'checkboxFORMATLAGERPLATZ', // Lagerplatz
        'checkboxMINPROFIL',        // Profiltiefe (⚠️ WICHTIG!)
        'checkboxPRUFDOC_ID'       // Prüfbericht
    ];
    
    let activatedCount = 0;
    
    for (const checkboxId of columnsToActivate) {
        try {
            const checkbox = await page.$(`#${checkboxId}`);
            
            if (checkbox) {
                const isChecked = await checkbox.isChecked();
                
                if (!isChecked) {
                    await checkbox.click();
                    await page.waitForTimeout(500); // Längere Pause zwischen Klicks
                    activatedCount++;
                }
            }
        } catch (error) {
            // Checkbox nicht gefunden, überspringe
        }
    }
    
    console.log(`   ✅ ${activatedCount} zusätzliche Spalten aktiviert`);
    
    // Schließe ColSelector wieder
    try {
        await page.click('button.button_colselect');
        await page.waitForTimeout(2000);
    } catch (error) {
        console.log('⚠️  Konnte ColSelector nicht schließen');
    }
    
    // Warte bis die Seite sich komplett neu geladen hat
    await page.waitForTimeout(5000);
}

module.exports = activateAllColumns;

